//
// nono
// Copyright (C) 2023 nono project
// Licensed under nono-license.txt
//

#pragma once

#include "header.h"
#include <vector>

class hd64180flag
{
 public:
	bool S {};
	bool Z {};
	bool H {};
	bool PV {};
	bool N {};
	bool C {};

	uint8 Get() const {
		uint8 data = 0;
		if (S)	data |= 0x80;
		if (Z)	data |= 0x40;
		if (H)	data |= 0x10;
		if (PV)	data |= 0x04;
		if (N)	data |= 0x02;
		if (C)	data |= 0x01;
		return data;
	}
};

static inline bool
vflag_add(uint32 dst, uint32 src, uint32 res)
{
	uint32 v = (src ^ res) & (dst ^ res);
	return (v & 0x80);
}

static inline bool
vflag_sub(uint32 dst, uint32 src, uint32 res)
{
	uint32 v = (src ^ dst) & (dst ^ res);
	return (v & 0x80);
}

static bool
hflag_add(uint32 dst, uint32 src)
{
	uint32 res = (dst & 0x0f) + (src & 0x0f);
	return (res & 0x10);
}

static bool
hflag_sub(uint32 dst, uint32 src)
{
	uint32 res = (dst & 0x0f) - (src & 0x0f);
	return (res & 0x10);
}

static bool
pflag(uint32 res)
{
	return ((__builtin_popcount(res) & 1) == 0);
}

extern void init(const char *name_, const char *method);
extern void out_testset();
extern void out_testdata_run1(uint32 dst, const hd64180flag& inflag,
	uint32 res, const hd64180flag& flag);
extern void out_testdata_run2(uint32 dst, const hd64180flag& inflag, uint32 src,
	uint32 res, const hd64180flag& flag);
extern void out(const char *fmt, ...);

extern const char *testname;
extern int testpos;
extern std::vector<std::string> testlist;
