//
// nono
// Copyright (C) 2021 nono project
// Licensed under nono-license.txt
//

//
// シリアルポートの標準入出力ドライバ
//

#pragma once

#include "comdriver.h"
#include <termios.h>

class COMDriverStdio : public COMDriver
{
	using inherited = COMDriver;
 public:
	explicit COMDriverStdio(HostDevice *hostdev_);
	~COMDriverStdio() override;

	bool InitDriver(bool startup) override;
	int Read() override;
	void Write(uint32 data) override;

 private:
	struct termios oldtc {};
	bool tc_changed {};

	// stdio を使えるのは同時に1人だけに限定する。
	static bool stdio_occupied;
};
