//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// 内蔵 ROM イメージ
//

#pragma once

#include "header.h"

class Builtin
{
 public:
	// cgrom.cpp
	static uint8 const CGROM[];

	// iplrom30.cpp
	static uint8 const IPLROM30[];

 public:
	// CGROM の特定のフォント/文字の開始アドレスを返す便利関数

	// 1バイト全角文字
	static const uint8 *CGROM8x8(uint ch = 0) {
		return &CGROM[0x3a000 + ch * 8];
	}
	static const uint8 *CGROM12x12(uint ch = 0) {
		return &CGROM[0x3b800 + ch * 24];
	}

	// 1バイト半角文字
	static const uint8 *CGROM6x12(uint ch = 0) {
		return &CGROM[0xbf400 + ch * 12];
	}
	static const uint8 *CGROM8x16(uint ch = 0) {
		return &CGROM[0x3a800 + ch * 16];
	}
	static const uint8 *CGROM12x24(uint ch = 0) {
		return &CGROM[0x3d000 + ch * 48];
	}

	// 2バイト全角文字
	static const uint8 *CGROM16x16(uint ch = 0) {
		return &CGROM[0x00000 + ch * 32];
	}
	static const uint8 *CGROM24x24(uint ch = 0) {
		return &CGROM[0x40000 + ch * 72];
	}
};
