//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// SCC (Z8530)
//

#pragma once

#include "mpscc.h"

class Keyboard;

class SCCDevice : public MPSCCDevice
{
	using inherited = MPSCCDevice;

 public:
	SCCDevice();
	~SCCDevice() override;

	bool Init() override;
	void ResetHard(bool poweron) override;

	// 割り込みアクノリッジ
	busdata InterruptAcknowledge();

 protected:
	// BusIO インタフェース
	busdata ReadPort(uint32 offset);
	busdata WritePort(uint32 offset, uint32 data);
	busdata PeekPort(uint32 offset);

	void Tx(int ch, uint32 data) override;
	uint GetHighestInt() const override;

 private:
	// 指定のレジスタ名を返す
	const char *CRName(const MPSCCChan&, uint n) const override;
	const char *SRName(const MPSCCChan&, uint n) const override;

	// WR, RR のほうが通りがいいので結局用意する
	const char *WRName(const MPSCCChan& chan, int n) const {
		return CRName(chan, n);
	}
	const char *WRName(const MPSCCChan& chan) const {
		return inherited::CRName(chan);
	}
	const char *RRName(const MPSCCChan& chan, int n) const {
		return SRName(chan, n);
	}
	const char *RRName(const MPSCCChan& chan) const {
		return inherited::SRName(chan);
	}

	void ResetChannel(MPSCCChan&);

	uint8 ReadCtrl(MPSCCChan&);
	void WriteCtrl(MPSCCChan&, uint32 data);
	uint8 PeekCtrl(const MPSCCChan&) const;

	uint8 GetWR1(const MPSCCChan&) const;
	uint8 GetWR9() const;
	uint8 GetRR0(const MPSCCChan&) const;
	uint8 GetRR2B() const;
	uint8 GetRR3A() const;

	void WriteWR0(MPSCCChan&, uint32 data);
	void WriteWR1(MPSCCChan&, uint32 data);
	void WriteWR2(uint32 data);
	void WriteWR5(MPSCCChan&, uint32 data);
	void WriteWR9(uint32 data);
	void WriteWR10(MPSCCChan&, uint32 data);
	void WriteWR11(MPSCCChan&, uint32 data);
	void WriteWR12(MPSCCChan&, uint32 data);
	void WriteWR13(MPSCCChan&, uint32 data);
	void WriteWR14(MPSCCChan&, uint32 data);
	void WriteWR15(MPSCCChan&, uint32 data);

	void SetXC(MPSCCChan&);

	DECLARE_MONITOR_SCREEN(MonitorScreen);
	void MonitorScreenCh(TextScreen&, int ch, int xbase, int ybase);

	// PCLK (入力クロック) の時間表現 [tsec]
	uint64 pclk_tsec {};

	Keyboard *keyboard {};

	static const char * const wrnames[32];
	static const char * const rrnames[32];
};

inline SCCDevice *GetSCCDevice() {
	return Object::GetObject<SCCDevice>(OBJ_MPSCC);
}
