//
// nono
// Copyright (C) 2020 nono project
// Licensed under nono-license.txt
//

//
// wx 側の共通ヘッダ
//

#pragma once

#include "nono.h"
#include "object.h"
#include "wxheader.h"

// ID はグローバルに一意でなければならないのでここで範囲割り当てだけ管理。
//
// monitor_id は自動生成のため ID を 0 から使用する。
// wxmainframe はそのすぐ次から使っていた仕組みを踏襲する。
// それ以外の ID は特に制約なく、適当に割り当てることができる。
enum {
	// monitor_id and
	// wxmainframe
	IDGROUP_MAINFRAME_END = 299,

	// wxdipswwindow
	IDGROUP_DIPSW,
	IDGROUP_DIPSW_END = IDGROUP_DIPSW + 19,

	// wxdumpmonitor
	IDGROUP_MEMDUMP,
	IDGROUP_MEMDUMP_END = IDGROUP_MEMDUMP + 9,

	// wxgvrammonitor
	IDGROUP_GVRAM,
	IDGROUP_GVRAM_END = IDGROUP_GVRAM + 9,

	// wxlogsetting
	IDGROUP_LOGSETTING,
	IDGROUP_LOGSETTING_END = IDGROUP_LOGSETTING + 199,

	// wxpagetablemonitor
	IDGROUP_PAGETABLE,
	IDGROUP_PAGETABLE_END = IDGROUP_PAGETABLE + 9,

	// wxtvrammonitor
	IDGROUP_TVRAM,
	IDGROUP_TVRAM_END = IDGROUP_TVRAM + 9,
};
