#
# nono
# Copyright (C) 2021 nono project
# Licensed under nono-license.txt
#

# object_id.txt から object_id.h, object_id.cpp を作る。
#
# usage: perl object_id.pl object_id.txt

{
	# ファイル名
	$infile = $ARGV[0];
	$hdrfile = $infile;
	$srcfile = $infile;
	$hdrfile =~ s/txt$/h/;
	$srcfile =~ s/txt$/cpp/;

	open(IN, $infile) || die "Cannot open infile: ${infile}\n";
	while (<IN>) {
		# Remove comments.
		chomp;
		s/^#.*$//;
		next if /^$/;

		@names = split(/\s+/);

		if (@names == 1) {
			$names[1] = $names[0];
		}
		$names[1] =~ s/^\"(.*)\"$/$1/;

		# %n があれば 0..(n-1) に展開する
		if ($names[0] =~ /%(\d+)/) {
			$atnum = $1 + 0;
			for ($i = 0; $i < $atnum; $i++) {
				@rep_names = ();
				$r = $names[0];
				$r =~ s/%${atnum}/${i}/g;
				push(@rep_names, $r);
				$r = $names[1];
				$r =~ s/%/${i}/g;
				push(@rep_names, $r);

				parse_line(@rep_names);
			}
		} else {
			parse_line(@names);
		}
	}

	# 文字列として出力
	$hdrnew = "";
	$srcnew = "";

	$hdrnew .= "// Generated from ${0}\n";
	$hdrnew .= "\n";
	$hdrnew .= "#pragma once\n";
	$hdrnew .= "\n";
	$hdrnew .= "enum {\n";
	$hdrnew	.= $defs;
	$hdrnew .= "};\n";

	$srcnew .= "// Generated from ${0}\n";
	$srcnew .= "\n";
	$srcnew .= "#include \"object.h\"\n";
	$srcnew .= "\n";
	$srcnew .= "/*static*/ const std::vector<const char *>\n";
	$srcnew .= "Object::idname {\n";
	$srcnew .= $msgs;
	$srcnew .= "};\n";
	$srcnew .= "\n";
	$srcnew .= "/*static*/ const std::vector<const char *>\n";
	$srcnew .= "Object::idtext {\n";
	$srcnew .= $text;
	$srcnew .= "};\n";

	# 更新があれば書き出す
	do_update($hdrfile, $hdrnew);
	do_update($srcfile, $srcnew);

	exit 0;
}

sub parse_line()
{
	local @names = @_;

	$defs .= "\tOBJ_${names[0]},\n";
	$msgs .= "\t\"${names[1]}\",\n";
	$text .= "\t\"OBJ_${names[0]}\",\n";
}

sub do_update()
{
	local $filename = $_[0];
	local $filebody = $_[1];
	local $old;
	local @contents;

	# まず出力先ファイルを文字列として読み込む
	$old = "";
	if (open(IN, $filename)) {
		@contents = <IN>;
		$old = join("", @contents);
		close(IN);
	}

	# 全文を比較して変更があれば出力
	if ($filebody ne $old) {
		open(OUT, ">${filename}") || die "Cannot open ${filename}\n";
		print OUT $filebody;
		close(OUT);
		print "Updated ${filename}\n";
	}
}
